<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800; color: var(--secondary);">Product Categories</h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Manage the types of machinery and equipment available on the platform.</p>
    </div>
    <a href="?route=product_type_create" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Add New Category</a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md); padding: 0;">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; background: var(--light-bg); color: var(--secondary); font-size: 0.85rem; text-transform: uppercase; letter-spacing: 0.5px;">
                <th style="padding: 1.25rem;">Category Name</th>
                <th style="padding: 1.25rem;">Description / Examples</th>
                <th style="padding: 1.25rem; text-align: center;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($types as $t): ?>
                <tr style="border-bottom: 1px solid var(--border); transition: background 0.2s;">
                    <td style="padding: 1.25rem;">
                        <div style="margin-left: <?php echo ($t['depth'] * 1.5); ?>rem; display: flex; align-items: center; gap: 0.5rem;">
                            <?php if ($t['depth'] > 0): ?>
                                <i class="fa-solid fa-turn-up fa-rotate-90" style="color: var(--border); font-size: 0.8rem;"></i>
                            <?php endif; ?>
                            <span style="font-weight: <?php echo $t['depth'] == 0 ? '800' : '600'; ?>; color: var(--secondary); <?php echo $t['depth'] == 0 ? 'text-transform: uppercase; letter-spacing: 0.5px;' : ''; ?>">
                                <?php echo $t['name']; ?>
                            </span>
                        </div>
                    </td>
                    <td style="padding: 1.25rem;">
                        <p style="color: var(--slate); margin-left: <?php echo ($t['depth'] * 1.5); ?>rem; font-size: 0.85rem; margin: 0; line-height: 1.4;"><?php echo $t['description'] ?? 'No description provided'; ?></p>
                    </td>
                    <td style="padding: 1.25rem; text-align: center;">
                        <div style="display: flex; gap: 0.5rem; justify-content: center;">
                            <a href="?route=product_type_edit&id=<?php echo $t['id']; ?>" class="action-btn" title="Edit">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </a>
                            <a href="?route=product_type_delete&id=<?php echo $t['id']; ?>" class="action-btn action-btn-danger" title="Delete" onclick="return confirm('Are you sure you want to delete this category?')">
                                <i class="fa-solid fa-trash"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
