<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800;">Membership Types</h1>
        <p style="color: var(--slate);">Manage company membership tiers and pricing.</p>
    </div>
    <a href="?route=membership_type_create" class="btn btn-primary">+ Add New Type</a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md);">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 2px solid var(--border);">
                <th style="padding: 1rem;">Type Name</th>
                <th style="padding: 1rem;">Price</th>
                <th style="padding: 1rem;">Companies</th>
                <th style="padding: 1rem;">Description</th>
                <th style="padding: 1rem; text-align: right;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($types)): ?>
                <tr>
                    <td colspan="5" style="padding: 2rem; text-align: center; color: var(--slate);">
                        <i class="fa-solid fa-inbox" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No membership types found. Create one to get started.
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($types as $type): ?>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 1rem;">
                        <span style="font-weight: 700; font-size: 1rem; color: var(--secondary);">
                            <?php echo htmlspecialchars($type['name']); ?>
                        </span>
                    </td>
                    <td style="padding: 1rem;">
                        <span style="color: var(--primary); font-weight: 600;">
                            ৳<?php echo number_format($type['price'], 2); ?>
                        </span>
                    </td>
                    <td style="padding: 1rem;">
                        <span style="background: var(--light-bg); padding: 0.25rem 0.75rem; border-radius: 12px; font-size: 0.85rem; font-weight: 600;">
                            <?php echo $type['company_count']; ?> companies
                        </span>
                    </td>
                    <td style="padding: 1rem; max-width: 300px;">
                        <span style="color: var(--slate); font-size: 0.85rem;">
                            <?php echo htmlspecialchars(substr($type['description'] ?? '', 0, 80)) . (strlen($type['description'] ?? '') > 80 ? '...' : ''); ?>
                        </span>
                    </td>
                    <td style="padding: 1rem; display: flex; gap: 0.5rem; justify-content: flex-end;">
                        <a href="?route=membership_type_edit&id=<?php echo $type['id']; ?>" class="action-btn action-btn-edit" title="Edit Membership Type">
                            <i class="fa-solid fa-pen-to-square"></i>
                        </a>
                        <?php if ($type['company_count'] == 0): ?>
                            <a href="?route=membership_type_delete&id=<?php echo $type['id']; ?>" class="action-btn action-btn-delete" title="Delete Type" onclick="return confirm('Delete this membership type?')">
                                <i class="fa-solid fa-trash-can"></i>
                            </a>
                        <?php else: ?>
                            <button class="action-btn" disabled title="Cannot delete - companies are assigned" style="opacity: 0.3; cursor: not-allowed;">
                                <i class="fa-solid fa-trash-can"></i>
                            </button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php if (!empty($types)): ?>
<div style="margin-top: 2rem; padding: 1rem; background: var(--light-bg); border-radius: 8px; border-left: 4px solid var(--primary);">
    <p style="color: var(--slate); margin: 0; font-size: 0.9rem;">
        <i class="fa-solid fa-circle-info"></i> 
        <strong>Note:</strong> Membership types cannot be deleted if companies are currently assigned to them.
    </p>
</div>
<?php endif; ?>
