<div style="max-width: 1200px; margin: 0 auto;">
    <a href="javascript:history.back()" style="display: inline-flex; align-items: center; gap: 0.5rem; color: var(--text-light); text-decoration: none; margin-bottom: 2rem; font-weight: 500;">
        <i class="fa-solid fa-arrow-left"></i> Back to Listings
    </a>

    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 3rem; align-items: start;">
        
        <!-- Left Column: Gallery & Details -->
        <div>
            <!-- Image Gallery -->
            <div class="card" style="padding: 1rem; margin-bottom: 2rem;">
                <div style="height: 500px; background: #f8fafc; border-radius: 8px; overflow: hidden; margin-bottom: 1rem; display: flex; align-items: center; justify-content: center; position: relative;">
                    <?php if (!empty($images)): ?>
                        <?php 
                            $primary = null;
                            foreach($images as $img) {
                                if($img['is_primary']) $primary = $img;
                            }
                            if(!$primary && count($images) > 0) $primary = $images[0];
                        ?>
                        <img id="mainImage" src="uploads/products/<?php echo $primary['image_path']; ?>" style="width: 100%; height: 100%; object-fit: contain;">
                    <?php else: ?>
                        <div style="color: var(--border); text-align: center;">
                            <i class="fa-solid fa-image fa-5x"></i>
                            <p style="margin-top: 1rem; font-weight: 500;">No images available</p>
                        </div>
                    <?php endif; ?>
                    
                    <span style="position: absolute; top: 1rem; right: 1rem; background: var(--primary); color: white; padding: 0.5rem 1rem; border-radius: 6px; font-weight: 700; text-transform: uppercase; font-size: 0.8rem; box-shadow: var(--shadow-sm);">
                        <?php echo $listing['listing_type']; ?>
                    </span>
                </div>

                <?php if (count($images) > 1): ?>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(80px, 1fr)); gap: 1rem;">
                        <?php foreach($images as $img): ?>
                            <div onclick="document.getElementById('mainImage').src = this.querySelector('img').src" 
                                 style="height: 80px; border-radius: 6px; overflow: hidden; cursor: pointer; border: 2px solid transparent; transition: all 0.2s;"
                                 onmouseover="this.style.borderColor = 'var(--primary)'"
                                 onmouseout="this.style.borderColor = 'transparent'">
                                <img src="uploads/products/<?php echo $img['image_path']; ?>" style="width: 100%; height: 100%; object-fit: cover;">
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Product Specs -->
            <div class="card">
                <h2 style="font-size: 1.5rem; margin-bottom: 1.5rem; padding-bottom: 1rem; border-bottom: 1px solid var(--border-light);">Specifications</h2>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Condition</label>
                        <div style="font-weight: 600; text-transform: capitalize;"><?php echo $listing['condition']; ?></div>
                    </div>
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Brand</label>
                        <div style="font-weight: 600;"><?php echo !empty($listing['brand_names']) ? $listing['brand_names'] : 'N/A'; ?></div>
                    </div>
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Year of Manufacture</label>
                        <div style="font-weight: 600;"><?php echo !empty($listing['manufacture_year']) ? $listing['manufacture_year'] : 'N/A'; ?></div>
                    </div>
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Model</label>
                        <div style="font-weight: 600;"><?php echo $listing['model']; ?></div>
                    </div>
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Origin</label>
                        <div style="font-weight: 600;"><?php echo !empty($listing['origin_country']) ? $listing['origin_country'] : 'N/A'; ?></div>
                    </div>
                    <div>
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.25rem;">Hours / Usage</label>
                        <div style="font-weight: 600;"><?php echo !empty($listing['usage_hours']) ? $listing['usage_hours'] . ' hours' : 'N/A'; ?></div>
                    </div>
                </div>

                <?php if (!empty($listing['description'])): ?>
                    <div style="margin-top: 2rem; padding-top: 2rem; border-top: 1px solid var(--border-light);">
                        <label style="display: block; color: var(--text-light); font-size: 0.9rem; margin-bottom: 0.5rem;">Description</label>
                        <div style="line-height: 1.6; color: var(--text);">
                            <?php echo nl2br(htmlspecialchars($listing['description'])); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Right Column: Info & Contact -->
        <div>
            <!-- Main Info Card -->
            <div class="card" style="margin-bottom: 2rem;">
                <h1 style="font-size: 1.8rem; line-height: 1.3; margin-bottom: 0.5rem;"><?php echo $listing['title']; ?></h1>
                <div style="color: var(--primary); font-weight: 600; margin-bottom: 1.5rem;"><?php echo $listing['category_name']; ?></div>

                <div style="display: flex; align-items: baseline; gap: 1rem; margin-bottom: 2rem;">
                    <div style="font-size: 2.5rem; font-weight: 800; color: var(--text);">
                        $<?php echo number_format($listing['price'], 2); ?>
                    </div>
                    <?php if ($listing['discounted_price'] > 0): ?>
                    <div style="color: var(--text-light); text-decoration: line-through; font-size: 1.2rem;">
                        $<?php echo number_format($listing['original_price'] ?? ($listing['price'] + $listing['discounted_price']), 2); // Assuming logic but typically discount implies price IS the discounted one or similar. Adjusting to just show price for now or simple if logic based on available fields. ?>
                    </div>
                    <?php endif; ?>
                </div>

                <div style="display: flex; gap: 1rem; margin-bottom: 1rem;">
                    <div style="flex: 1; text-align: center; padding: 1rem; background: #f8fafc; border-radius: 8px;">
                        <div style="color: var(--text-light); font-size: 0.8rem; text-transform: uppercase; font-weight: 700;">Stock</div>
                        <div style="font-size: 1.2rem; font-weight: 600; margin-top: 0.25rem;">
                            <?php echo $listing['quantity'] > 0 ? $listing['quantity'] . ' Units' : 'Out of Stock'; ?>
                        </div>
                    </div>
                    <div style="flex: 1; text-align: center; padding: 1rem; background: #f8fafc; border-radius: 8px;">
                        <div style="color: var(--text-light); font-size: 0.8rem; text-transform: uppercase; font-weight: 700;">Location</div>
                        <div style="font-size: 1.2rem; font-weight: 600; margin-top: 0.25rem;">
                            <?php echo !empty($company['state']) ? $company['state'] . ', ' . $company['country'] : 'N/A'; ?>
                        </div>
                    </div>
                </div>

                <a href="#contact" style="display: flex; align-items: center; justify-content: center; width: 100%; padding: 1rem; background: var(--primary); color: white; font-weight: 700; border-radius: 8px; text-decoration: none; transition: background 0.2s;">
                    <i class="fa-regular fa-envelope" style="margin-right: 0.5rem;"></i> Cntact Seller
                </a>
            </div>

            <!-- Seller Info -->
            <div id="contact" class="card">
                <h3 style="font-size: 1.2rem; margin-bottom: 1.5rem;">Seller Information</h3>
                
                <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                    <?php if (!empty($company['logo'])): ?>
                        <img src="uploads/logos/<?php echo $company['logo']; ?>" style="width: 64px; height: 64px; border-radius: 12px; object-fit: cover; border: 1px solid var(--border);">
                    <?php else: ?>
                        <div style="width: 64px; height: 64px; border-radius: 12px; background: var(--secondary); color: white; display: flex; align-items: center; justify-content: center;">
                            <i class="fa-solid fa-building fa-lg"></i>
                        </div>
                    <?php endif; ?>
                    <div>
                        <h4 style="font-size: 1.1rem; font-weight: 700; margin-bottom: 0.25rem;"><?php echo $company['name']; ?></h4>
                        <a href="?route=company_view&uuid=<?php echo $company['uuid']; ?>" style="color: var(--primary); font-size: 0.9rem; text-decoration: none;">View Full Portfolio</a>
                    </div>
                </div>

                <div style="display: flex; flex-direction: column; gap: 1rem;">
                    <div style="display: flex; align-items: center; gap: 1rem; color: var(--text);">
                        <div style="width: 32px; height: 32px; border-radius: 50%; background: #f0f4f8; display: flex; align-items: center; justify-content: center; color: var(--primary);">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <span style="font-size: 0.95rem;">
                            <?php 
                                echo implode(', ', array_filter([
                                    $company['address'], 
                                    $company['city'], 
                                    $company['state'], 
                                    $company['zip'], 
                                    $company['country']
                                ])); 
                            ?>
                        </span>
                    </div>

                    <div style="display: flex; align-items: center; gap: 1rem; color: var(--text);">
                        <div style="width: 32px; height: 32px; border-radius: 50%; background: #f0f4f8; display: flex; align-items: center; justify-content: center; color: var(--primary);">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <span style="font-size: 0.95rem; font-weight: 600;">
                            <?php echo !empty($company['phone']) ? $company['phone'] : 'Phone not listed'; ?>
                        </span>
                    </div>

                    <div style="display: flex; align-items: center; gap: 1rem; color: var(--text);">
                        <div style="width: 32px; height: 32px; border-radius: 50%; background: #f0f4f8; display: flex; align-items: center; justify-content: center; color: var(--primary);">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <span style="font-size: 0.95rem;">
                            <?php echo !empty($company['email']) ? $company['email'] : 'Email not listed'; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media (max-width: 900px) {
        div[style*="display: grid; grid-template-columns: 2fr 1fr;"] {
            grid-template-columns: 1fr !important;
        }
    }
</style>
