<h1>Industrial Machinery for <?php echo ucfirst($type); ?></h1>
<p>Showing latest high-performance equipment.</p>

<div class="grid-auto" style="margin-top: 2rem;">
            <?php foreach ($listings as $l): ?>
                <div class="card" style="padding: 0; overflow: hidden; display: flex; flex-direction: column; height: 100%;">
                    <a href="?route=listing_view&id=<?php echo $l['id']; ?>" style="display: block; height: 180px; background: #f0f4f8; position: relative; text-decoration: none;">
                        <?php if (!empty($l['primary_image'])): ?>
                            <img src="uploads/products/<?php echo $l['primary_image']; ?>" style="width: 100%; height: 100%; object-fit: cover;">
                        <?php else: ?>
                            <div style="width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; color: var(--border);">
                                <i class="fa-solid fa-image fa-3x"></i>
                            </div>
                        <?php endif; ?>
                        <div style="position: absolute; top: 1rem; right: 1rem; display: flex; flex-direction: column; gap: 0.5rem; align-items: flex-end;">
                            <span style="background: rgba(255,255,255,0.9); padding: 0.25rem 0.6rem; border-radius: 4px; font-size: 0.7rem; font-weight: 700; color: var(--secondary); box-shadow: var(--shadow-sm); text-transform: capitalize;">
                                <?php echo $l['condition']; ?>
                            </span>
                            <span style="background: var(--primary); color: white; padding: 0.25rem 0.6rem; border-radius: 4px; font-size: 0.7rem; font-weight: 800; box-shadow: var(--shadow-sm); text-transform: uppercase;">
                                <?php echo $l['listing_type']; ?>
                            </span>
                        </div>
                    </a>
                    <div style="padding: 1.25rem; flex-grow: 1; display: flex; flex-direction: column;">
                        <div style="font-size: 0.75rem; font-weight: 600; color: var(--primary); margin-bottom: 0.4rem; text-transform: uppercase; letter-spacing: 0.5px;">
                            <?php echo \Models\ProductType::getCategoryPath($l['product_type_id'] ?? '', $category_map); ?>
                        </div>
                        <h3 style="font-size: 1.1rem; font-weight: 800; color: var(--secondary); margin-bottom: 0.25rem;">
                            <a href="?route=listing_view&id=<?php echo $l['id']; ?>" style="color: inherit; text-decoration: none;"><?php echo htmlspecialchars($l['title']); ?></a>
                        </h3>
                        <div style="font-size: 0.8rem; font-family: monospace; color: var(--slate); margin-bottom: 0.75rem;">Model: <?php echo htmlspecialchars($l['model_name'] ?: 'N/A'); ?></div>
                        
                        <div style="display: flex; gap: 0.35rem; flex-wrap: wrap; margin-bottom: 1.25rem;">
                            <?php if (!empty($l['brand_names'])): ?>
                                <?php foreach (explode(', ', $l['brand_names']) as $brand): ?>
                                    <span style="background: var(--light-bg); color: var(--secondary); font-size: 0.6rem; font-weight: 700; padding: 0.1rem 0.4rem; border-radius: 4px; border: 1px solid var(--border);"><?php echo htmlspecialchars($brand); ?></span>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>

                        <div style="margin-top: auto; display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <div style="font-size: 0.7rem; color: var(--slate); font-weight: 600; text-transform: uppercase;">Price</div>
                                <div style="font-size: 1.25rem; font-weight: 800; color: var(--accent);">$<?php echo number_format($l['price'], 0); ?></div>
                            </div>
                            <a href="?route=listing_view&id=<?php echo $l['id']; ?>" class="btn btn-primary" style="padding: 0.5rem 1rem; font-size: 0.85rem;">View Details</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
</div>

<?php if (isset($pagination) && $pagination['total_pages'] > 1): ?>
    <div style="display: flex; justify-content: center; margin-top: 2rem; margin-bottom: 2rem; gap: 0.5rem;">
        <?php 
        $urlParams = $_GET;
        unset($urlParams['page']);
        $baseUrl = '?' . http_build_query($urlParams);
        ?>
        
        <?php if ($pagination['current_page'] > 1): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] - 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                <i class="fa-solid fa-chevron-left"></i> Previous
            </a>
        <?php endif; ?>
        
        <div style="display: flex; gap: 0.25rem;">
            <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                <a href="<?php echo $baseUrl . '&page=' . $i; ?>" class="btn" style="<?php echo $i === $pagination['current_page'] ? 'background: var(--primary); color: white;' : 'background: white; border: 1px solid var(--border); color: var(--secondary);'; ?> padding: 0.5rem 1rem;">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
        </div>

        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] + 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                Next <i class="fa-solid fa-chevron-right"></i>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>
