<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2.5rem;">
    <div style="display: flex; align-items: center; gap: 1.5rem;">
        <?php if (!empty($company['logo'])): ?>
            <img src="uploads/logos/<?php echo $company['logo']; ?>" style="width: 64px; height: 64px; border-radius: 12px; object-fit: cover; border: 1px solid var(--border);">
        <?php else: ?>
            <div style="width: 64px; height: 64px; border-radius: 12px; background: var(--secondary); color: white; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">
                <i class="fa-solid fa-building"></i>
            </div>
        <?php endif; ?>
        <div>
            <h1 style="font-weight: 800; color: var(--secondary); margin: 0;"><?php echo $company['name']; ?></h1>
            <p style="color: var(--slate); font-size: 0.95rem; margin-top: 0.25rem;">
                <i class="fa-solid fa-circle-check" style="color: var(--accent);"></i> Authorized Merchant Profile
            </p>
        </div>
    </div>
</div>

<div class="grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1rem; margin-bottom: 2rem;">
    <div class="card" style="border-left: 5px solid var(--primary); padding: 1rem;">
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">OPERATORS</h5>
        <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $userCount; ?> Active</h2>
        <button class="btn" style="padding: 0; color: var(--primary); font-size: 0.75rem; margin-top: 0.25rem; font-weight: 600;" onclick="window.location.href='?route=user_list'">Manage Team →</button>
    </div>
    <a href="?route=listing_list" style="text-decoration: none; color: inherit;">
        <div class="card" style="border-left: 5px solid var(--secondary); padding: 1rem; cursor: pointer; transition: transform 0.2s, box-shadow 0.2s;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)'">
            <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">LISTINGS</h5>
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $listings['total']; ?> Total</h2>
                <i class="fa-solid fa-arrow-right" style="color: var(--slate); font-size: 0.9rem;"></i>
            </div>
        </div>
    </a>
    <div class="card" style="border-left: 5px solid var(--accent); padding: 1rem;">
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">PORTFOLIO</h5>
        <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $listings['sell_count']; ?> Sales</h2>
    </div>
</div>

<div class="grid" style="margin-top: 2rem; grid-template-columns: 2fr 1fr;">
    <div class="card">
        <h3>Company Profile</h3>
        <div style="margin-top: 1rem; border-top: 1px solid var(--border); padding-top: 1rem;">
            <p style="margin-bottom: 0.5rem;"><strong>Business Category:</strong> <?php echo $company['type']; ?></p>
            <p style="margin-bottom: 0.5rem;"><strong>Location:</strong> <?php echo $company['address']; ?></p>
            <?php if ($company['status'] === 'active'): ?>
                <a href="?route=company_edit&id=<?php echo $_SESSION['company_id']; ?>" class="btn btn-primary" style="margin-top: 1rem; text-decoration: none; display: inline-block;">Edit Business Profile</a>
            <?php else: ?>
                <p style="color: var(--accent); font-weight: 600; margin-top: 1rem;">
                    <i class="fa-solid fa-circle-info"></i> Profile editing is disabled (<?php echo ucfirst($company['status']); ?>)
                </p>
            <?php endif; ?>
        </div>
    </div>
    <div class="card">
        <h3>Listing Portfolio</h3>
        <p style="color: var(--slate); margin-top: 1rem;">For Sale: <?php echo $listings['sell_count']; ?></p>
        <p style="color: var(--secondary); margin-top: 0.5rem;">For Rent: <?php echo $listings['rent_count']; ?></p>
        <button class="btn" style="margin-top: 1.5rem; background: var(--light-bg); width: 100%;" onclick="window.location.href='?route=listing_list'">Manage Inventory</button>
    </div>
</div>
