<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800;">Company Management</h1>
        <p style="color: var(--slate);">Manage registered machinery and equipment providers.</p>
    </div>
    <a href="?route=company_create" class="btn btn-primary">+ Register New Company</a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md); padding: 0;">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 2px solid var(--border);">
                <th style="padding: 1rem; width: 50px;">Logo</th>
                <th style="padding: 1rem;">Company Name</th>
                <th style="padding: 1rem;">Email</th>
                <th style="padding: 1rem;">Phone</th>
                <th style="padding: 1rem;">Type</th>
                <th style="padding: 1rem;">Membership</th>
                <th style="padding: 1rem; text-align: center;">Products</th>
                <th style="padding: 1rem;">Status</th>
                <th style="padding: 1rem;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($companies)): ?>
                <tr>
                    <td colspan="9" style="padding: 2rem; text-align: center; color: var(--slate);">No companies registered yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($companies as $comp): ?>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 1rem;">
                        <?php if (!empty($comp['logo'])): ?>
                            <img src="uploads/logos/<?php echo $comp['logo']; ?>" style="width: 32px; height: 32px; border-radius: 4px; object-fit: cover; border: 1px solid var(--border);">
                        <?php else: ?>
                            <div style="width: 32px; height: 32px; border-radius: 4px; background: var(--light-bg); display: flex; align-items: center; justify-content: center; color: var(--slate); border: 1px solid var(--border);">
                                <i class="fa-solid fa-building" style="font-size: 0.8rem;"></i>
                            </div>
                        <?php endif; ?>
                    </td>
                    <td style="padding: 1rem; font-weight: 600;">
                        <a href="?route=company_view&id=<?php echo $comp['id']; ?>" style="color: var(--secondary); text-decoration: none; border-bottom: 1px dashed var(--border);">
                            <?php echo $comp['name']; ?>
                        </a>
                    </td>
                    <td style="padding: 1rem; color: var(--slate);"><?php echo $comp['email']; ?></td>
                    <td style="padding: 1rem; color: var(--slate);"><?php echo $comp['phone']; ?></td>
                    <td style="padding: 1rem;">
                        <?php 
                            $typeIcons = [
                                'Manufacturing' => 'fa-industry',
                                'Garments' => 'fa-shirt',
                                'ELECTRICAL lift' => 'fa-elevator',
                                'Road and bridge' => 'fa-bridge'
                            ];
                        ?>
                        <i class="fa-solid <?php echo $typeIcons[$comp['type']] ?? 'fa-building'; ?>" title="<?php echo $comp['type']; ?>" style="color: var(--primary); font-size: 1.1rem;"></i>
                    </td>
                    <td style="padding: 1rem;">
                        <?php if (!empty($comp['membership_type_name'])): ?>
                            <?php 
                                $membershipColors = [
                                    'Gold' => ['bg' => '#fef3c7', 'text' => '#92400e', 'icon' => '⭐'],
                                    'Silver' => ['bg' => '#e5e7eb', 'text' => '#374151', 'icon' => '✨'],
                                    'Basic' => ['bg' => '#dbeafe', 'text' => '#1e40af', 'icon' => '📦']
                                ];
                                $style = $membershipColors[$comp['membership_type_name']] ?? ['bg' => '#f3f4f6', 'text' => '#6b7280', 'icon' => '📋'];
                            ?>
                            <span style="background: <?php echo $style['bg']; ?>; color: <?php echo $style['text']; ?>; padding: 0.35rem 0.75rem; border-radius: 16px; font-size: 0.75rem; font-weight: 700; display: inline-flex; align-items: center; gap: 0.35rem;">
                                <span><?php echo $style['icon']; ?></span>
                                <?php echo htmlspecialchars($comp['membership_type_name']); ?>
                            </span>
                        <?php else: ?>
                            <span style="color: var(--slate); font-size: 0.75rem; font-style: italic;">Free</span>
                        <?php endif; ?>
                    </td>
                    <td style="padding: 1rem; text-align: center;">
                        <span style="display: inline-flex; align-items: center; gap: 0.5rem; padding: 0.25rem 0.75rem; background: var(--light-bg); border-radius: 12px; font-weight: 600; color: var(--secondary); font-size: 0.9rem;">
                            <i class="fa-solid fa-box" style="font-size: 0.85rem;"></i>
                            <?php echo $comp['product_count'] ?? 0; ?>
                        </span>
                    </td>
                    <td style="padding: 1rem;">
                        <i class="fa-solid fa-circle" style="color: <?php echo $comp['status'] === 'active' ? 'var(--accent)' : ($comp['status'] === 'pending' ? 'var(--secondary)' : '#e74c3c'); ?>; font-size: 0.8rem;" title="<?php echo ucfirst($comp['status']); ?>"></i>
                    </td>
                    <td style="padding: 1rem; display: flex; gap: 0.5rem;">
                        <a href="?route=company_edit&id=<?php echo $comp['id']; ?>" class="action-btn action-btn-edit" title="Edit Company">
                            <i class="fa-solid fa-pen-to-square"></i>
                        </a>
                        <a href="?route=company_suspend&id=<?php echo $comp['id']; ?>" class="action-btn action-btn-delete" title="Suspend Company" onclick="return confirm('Change status of this company?')">
                            <i class="fa-solid fa-ban"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
