<h1><?php echo isset($company) ? 'Edit Company' : 'Register New Company'; ?></h1>

<div class="card" style="margin-top: 2rem;">
    <form action="?route=company_save" method="POST" enctype="multipart/form-data" style="display: flex; flex-direction: column; gap: 1.5rem;">
        <?php if (isset($company)): ?>
            <input type="hidden" name="id" value="<?php echo $company['id']; ?>">
            <input type="hidden" name="existing_logo" value="<?php echo $company['logo'] ?? ''; ?>">
        <?php endif; ?>

        <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1.5rem;">
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Company Name</label>
                <input type="text" name="name" value="<?php echo $company['name'] ?? ''; ?>" required>
            </div>
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Company Email</label>
                <input type="email" name="email" value="<?php echo $company['email'] ?? ''; ?>" required>
            </div>
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Phone Number</label>
                <input type="text" name="phone" value="<?php echo $company['phone'] ?? ''; ?>" required placeholder="+880 1234-567890">
            </div>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Company Type</label>
                <?php if ($_SESSION['role'] === 'super_admin'): ?>
                    <select name="type" required>
                        <option value="">Select Category</option>
                        <?php foreach ($types as $t): ?>
                            <option value="<?php echo $t['name']; ?>" <?php echo (isset($company) && $company['type'] == $t['name']) ? 'selected' : ''; ?>>
                                <?php echo $t['name']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php else: ?>
                    <input type="text" value="<?php echo $company['type']; ?>" readonly style="background: var(--light-bg); cursor: not-allowed; font-weight: 600;">
                    <input type="hidden" name="type" value="<?php echo $company['type']; ?>">
                <?php endif; ?>
            </div>
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Membership Type</label>
                <?php if ($_SESSION['role'] === 'super_admin'): ?>
                    <select name="membership_type_id" required>
                        <option value="">Select Membership Type</option>
                        <?php foreach ($membership_types as $mt): ?>
                            <?php 
                                // Auto-select Basic for new companies, or selected membership for existing
                                $isSelected = false;
                                if (isset($company)) {
                                    $isSelected = ($company['membership_type_id'] == $mt['id']);
                                } else {
                                    $isSelected = (strtolower($mt['name']) === 'basic');
                                }
                            ?>
                            <option value="<?php echo $mt['id']; ?>" <?php echo $isSelected ? 'selected' : ''; ?>>
                                <?php echo $mt['name']; ?> - ৳<?php echo number_format($mt['price'], 2); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php else: ?>
                    <input type="text" value="<?php echo $company['membership_type_name'] ?? 'None'; ?>" readonly style="background: var(--light-bg); cursor: not-allowed; font-weight: 600;">
                    <input type="hidden" name="membership_type_id" value="<?php echo $company['membership_type_id'] ?? ''; ?>">
                <?php endif; ?>
            </div>
        </div>

        <div style="display: grid; grid-template-columns: 1fr; gap: 1.5rem;">
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Company Logo</label>
                <div style="display: flex; align-items: center; gap: 1rem;">
                    <?php if (isset($company) && !empty($company['logo'])): ?>
                        <img src="uploads/logos/<?php echo $company['logo']; ?>" style="width: 40px; height: 40px; border-radius: 4px; object-fit: cover; border: 1px solid var(--border);">
                    <?php endif; ?>
                    <input type="file" name="logo" accept="image/*" style="padding: 0.4rem;">
                </div>
            </div>
            
            <div>
                <label style="display: block; margin-bottom: 0.5rem;">Company Banner</label>
                <div style="display: flex; align-items: center; gap: 1rem;">
                    <?php if (isset($company) && !empty($company['banner'])): ?>
                        <img src="uploads/banners/<?php echo $company['banner']; ?>" style="width: 120px; height: 40px; border-radius: 4px; object-fit: cover; border: 1px solid var(--border);">
                        <input type="hidden" name="existing_banner" value="<?php echo $company['banner']; ?>">
                    <?php endif; ?>
                    <input type="file" name="banner" accept="image/*" style="padding: 0.4rem;">
                    <small style="color: var(--slate);">Recommended: 1200x300px</small>
                </div>
            </div>
        </div>

        <div>
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
                <label style="font-weight: 700; color: var(--secondary);">Machinery Portfolio (Allowed Categories)</label>
                <div id="category-limit-info" style="display: none; padding: 0.5rem 1rem; background: #fef3c7; border: 1px solid #f59e0b; border-radius: 6px; font-size: 0.85rem; font-weight: 600; color: #92400e;">
                    <i class="fa-solid fa-info-circle"></i> <span id="category-count">0</span> / <span id="category-max">∞</span> selected
                </div>
            </div>
            <?php if ($_SESSION['role'] === 'super_admin'): ?>
                <div id="category-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 1rem; background: var(--light-bg); padding: 1.5rem; border-radius: 8px; border: 1px solid var(--border);">
                    <?php foreach ($product_categories as $pc): ?>
                        <label class="category-checkbox-label" style="display: flex; align-items: center; gap: 0.75rem; cursor: pointer; padding: 0.5rem; background: white; border-radius: 6px; border: 1px solid var(--border);">
                            <input type="checkbox" class="category-checkbox" name="product_categories[]" value="<?php echo $pc['id']; ?>" 
                                <?php echo (isset($assigned_categories) && in_array($pc['id'], $assigned_categories)) ? 'checked' : ''; ?>
                                style="width: 18px; height: 18px; accent-color: var(--primary);">
                            <span style="font-size: 0.85rem; font-weight: 600; color: var(--secondary);"><?php echo $pc['name']; ?></span>
                        </label>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div style="display: flex; flex-wrap: wrap; gap: 0.75rem;">
                    <?php 
                        $assignedNow = \Models\Company::getProductTypes($company['id']);
                        if (empty($assignedNow)):
                    ?>
                        <p style="color: var(--slate); font-style: italic;">No categories assigned yet.</p>
                    <?php else: ?>
                        <?php foreach ($assignedNow as $apc): ?>
                            <span style="background: var(--light-bg); color: var(--primary); padding: 0.5rem 1rem; border-radius: 20px; font-size: 0.8rem; font-weight: 700; border: 1px solid var(--primary-light);">
                                <i class="fa-solid fa-check-circle"></i> <?php echo $apc['name']; ?>
                            </span>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem;">Business Address</label>
            <textarea name="address" required style="min-height: 100px;"><?php echo $company['address'] ?? ''; ?></textarea>
        </div>

        <?php if ($_SESSION['role'] === 'super_admin'): ?>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
                <div>
                    <label style="display: block; margin-bottom: 0.5rem;">Status</label>
                    <select name="status">
                        <option value="active" <?php echo (isset($company) && $company['status'] == 'active') ? 'selected' : ''; ?>>Active</option>
                        <option value="pending" <?php echo (isset($company) && $company['status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                        <option value="suspended" <?php echo (isset($company) && $company['status'] == 'suspended') ? 'selected' : ''; ?>>Suspended</option>
                    </select>
                </div>
            </div>
        <?php else: ?>
            <input type="hidden" name="status" value="<?php echo $company['status']; ?>">
        <?php endif; ?>

        <div style="display: flex; gap: 1rem; margin-top: 1rem;">
            <button type="submit" class="btn btn-primary">Save Company Record</button>
            <a href="?route=<?php echo $_SESSION['role'] === 'super_admin' ? 'company_list' : 'company_admin'; ?>" class="btn" style="background: #eee; text-decoration: none; color: #333; line-height: 1.2;">Cancel</a>
        </div>
    </form>
</div>

<script>
// Category limit enforcement based on membership type
const membershipLimits = {
    <?php foreach ($membership_types as $mt): ?>
    '<?php echo $mt['id']; ?>': <?php echo $mt['category_limit'] ?? 'null'; ?>,
    <?php endforeach; ?>
};

const membershipSelect = document.querySelector('select[name="membership_type_id"]');
const categoryCheckboxes = document.querySelectorAll('.category-checkbox');
const categoryLabels = document.querySelectorAll('.category-checkbox-label');
const limitInfo = document.getElementById('category-limit-info');
const categoryCount = document.getElementById('category-count');
const categoryMax = document.getElementById('category-max');

function updateCategoryLimits() {
    const selectedMembership = membershipSelect.value;
    const limit = membershipLimits[selectedMembership];
    
    if (limit === null || limit === undefined) {
        // No limit or unlimited
        limitInfo.style.display = 'none';
        categoryCheckboxes.forEach(cb => cb.disabled = false);
        categoryLabels.forEach(label => {
            label.style.opacity = '1';
            label.style.cursor = 'pointer';
        });
        return;
    }
    
    // Show limit info
    limitInfo.style.display = 'block';
    categoryMax.textContent = limit;
    
    const checkedCount = Array.from(categoryCheckboxes).filter(cb => cb.checked).length;
    categoryCount.textContent = checkedCount;
    
    // Update styling based on limit
    if (checkedCount >= limit) {
        limitInfo.style.background = '#fee2e2';
        limitInfo.style.borderColor = '#ef4444';
        limitInfo.style.color = '#991b1b';
    } else {
        limitInfo.style.background = '#fef3c7';
        limitInfo.style.borderColor = '#f59e0b';
        limitInfo.style.color = '#92400e';
    }
    
    // Disable unchecked checkboxes if limit reached
    categoryCheckboxes.forEach((cb, index) => {
        if (!cb.checked && checkedCount >= limit) {
            cb.disabled = true;
            categoryLabels[index].style.opacity = '0.4';
            categoryLabels[index].style.cursor = 'not-allowed';
        } else {
            cb.disabled = false;
            categoryLabels[index].style.opacity = '1';
            categoryLabels[index].style.cursor = 'pointer';
        }
    });
}

// Listen for membership change
if (membershipSelect) {
    membershipSelect.addEventListener('change', updateCategoryLimits);
}

// Listen for category checkbox changes
categoryCheckboxes.forEach(cb => {
    cb.addEventListener('change', updateCategoryLimits);
});

// Initial check on page load
updateCategoryLimits();
</script>
