<div style="margin: 0 auto;">
    <div style="margin-bottom: 2rem;">
        <h1 style="font-weight: 800; color: var(--secondary);"><?php echo isset($brand) ? 'Edit Brand' : 'Add New Brand'; ?></h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Register a global equipment manufacturer.</p>
    </div>

    <form action="?route=brand_save" method="POST" enctype="multipart/form-data" class="card" style="display: flex; flex-direction: column; gap: 1.5rem; border: none; box-shadow: var(--shadow-md);">
        <?php if (isset($brand)): ?>
            <input type="hidden" name="id" value="<?php echo $brand['id']; ?>">
        <?php endif; ?>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Brand Name</label>
            <input type="text" name="name" value="<?php echo $brand['name'] ?? ''; ?>" required placeholder="e.g. Caterpillar, Walton, GREE" style="width: 100%;">
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
            <div>
                <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Country of Origin</label>
                <input type="text" name="country_of_origin" value="<?php echo $brand['country_of_origin'] ?? ''; ?>" placeholder="e.g. USA, Bangladesh, China" style="width: 100%;">
            </div>
            <div>
                <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Custom Slug (Optional)</label>
                <input type="text" name="brand_slug" value="<?php echo $brand['brand_slug'] ?? ''; ?>" placeholder="e.g. caterpillar-heavy" style="width: 100%;">
                <small style="color: var(--slate); display: block; margin-top: 0.25rem;">Leave blank to auto-generate from name.</small>
            </div>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Brand Logo</label>
            <?php if (!empty($brand['logo'])): ?>
                <div style="margin-bottom: 1rem;">
                    <img src="uploads/brands/<?php echo $brand['logo']; ?>" style="width: 100px; height: 60px; object-fit: contain; border: 1px solid var(--border); border-radius: 8px; padding: 0.5rem;">
                </div>
            <?php endif; ?>
            <input type="file" name="logo" accept="image/*" style="width: 100%; padding: 0.5rem; border: 1px dashed var(--border); border-radius: 8px;">
            <small style="color: var(--slate); display: block; margin-top: 0.25rem;">Transparent PNG or SVG recommended.</small>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Description</label>
            <textarea name="description" placeholder="Brief history or specializations..." style="width: 100%; min-height: 120px;"><?php echo $brand['description'] ?? ''; ?></textarea>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 1rem;">
            <button type="submit" class="btn btn-primary" style="flex: 2;">Save Brand</button>
            <a href="?route=brand_list" class="btn" style="flex: 1; background: var(--light-bg); color: var(--slate); text-align: center; text-decoration: none;">Cancel</a>
        </div>
    </form>
</div>
