<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    $db->beginTransaction();

    // Helper to add UUID column and populate it
    function addUuidToTable($db, $tableName) {
        echo "Updating $tableName...\n";
        // Check if uuid exists first to allow re-runs
        $db->exec("ALTER TABLE $tableName ADD COLUMN uuid CHAR(36) UNIQUE NULL AFTER id");
        
        // Populate with UUIDs
        $stmt = $db->query("SELECT id FROM $tableName WHERE uuid IS NULL");
        $results = $stmt->fetchAll();
        
        $updateStmt = $db->prepare("UPDATE $tableName SET uuid = UUID() WHERE id = ?");
        foreach ($results as $row) {
            $updateStmt->execute([$row['id']]);
        }
        
        // Make it NOT NULL and UNIQUE for real
        $db->exec("ALTER TABLE $tableName MODIFY COLUMN uuid CHAR(36) NOT NULL UNIQUE");
        echo "$tableName UUIDs generated.\n";
    }

    addUuidToTable($db, 'users');
    addUuidToTable($db, 'companies');
    addUuidToTable($db, 'product_types');
    addUuidToTable($db, 'brands');

    // We also need a 'categories' table mentioned in the spec if it doesn't exist
    $db->exec("CREATE TABLE IF NOT EXISTS categories (
        id CHAR(36) PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        parent_id CHAR(36) NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Also company_locations for the logistics FK
    $db->exec("CREATE TABLE IF NOT EXISTS company_locations (
        id CHAR(36) PRIMARY KEY,
        company_id CHAR(36) NOT NULL,
        name VARCHAR(255) NOT NULL,
        address TEXT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    $db->commit();
    echo "Core tables UUID migration and new tables created successfully.";
} catch (Exception $e) {
    if ($db->inTransaction()) $db->rollBack();
    echo "Error: " . $e->getMessage();
}
