<?php
// Migration: Set Basic Membership for Existing Companies
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';

try {
    $db = Core\Database::getInstance();
    
    echo "Starting update for existing companies...\n\n";
    
    // Get the Basic membership type ID
    $stmt = $db->prepare("SELECT id FROM membership_types WHERE LOWER(name) = 'basic'");
    $stmt->execute();
    $basic = $stmt->fetch();
    
    if (!$basic) {
        echo "❌ Error: Basic membership type not found!\n";
        echo "Please run migrate_membership_types.php first.\n";
        exit(1);
    }
    
    $basicId = $basic['id'];
    echo "✓ Found Basic membership type (ID: {$basicId})\n\n";
    
    // Find companies without a membership type
    $stmt = $db->query("SELECT id, name FROM companies WHERE membership_type_id IS NULL");
    $companies = $stmt->fetchAll();
    
    if (empty($companies)) {
        echo "ℹ No companies need updating. All companies already have a membership type.\n";
    } else {
        echo "Found " . count($companies) . " companies without membership type:\n\n";
        
        // Update each company to Basic membership
        $updateStmt = $db->prepare("UPDATE companies SET membership_type_id = ? WHERE id = ?");
        
        foreach ($companies as $company) {
            $updateStmt->execute([$basicId, $company['id']]);
            echo "  ✓ Updated: {$company['name']} → Basic membership\n";
        }
        
        echo "\n✅ Successfully updated " . count($companies) . " companies to Basic membership!\n";
    }
    
} catch (PDOException $e) {
    echo "\n❌ Migration failed: " . $e->getMessage() . "\n";
    echo "Error Code: " . $e->getCode() . "\n";
}
