<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    // Check if is_active column exists before removing it
    $checkColumn = $db->query("SHOW COLUMNS FROM products LIKE 'is_active'");
    
    if ($checkColumn->rowCount() > 0) {
        // Remove is_active column from products table
        $db->exec("ALTER TABLE products DROP COLUMN is_active");
        echo "✓ Successfully removed 'is_active' column from products table.\n";
        echo "Products will now use the 'status' field only.\n";
    } else {
        echo "ℹ Column 'is_active' does not exist in products table. No changes needed.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
