<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    echo "Creating product_images table...\n";
    
    $sql = "CREATE TABLE IF NOT EXISTS product_images (
        id CHAR(36) PRIMARY KEY,
        product_id CHAR(36) NOT NULL,
        image_path VARCHAR(255) NOT NULL,
        is_primary BOOLEAN DEFAULT FALSE,
        sort_order INT DEFAULT 0,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX (product_id),
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE
    ) ENGINE=InnoDB";
    
    $db->exec($sql);
    
    echo "✅ product_images table created successfully!\n";
    echo "Columns:\n";
    echo "- id (VARCHAR 36)\n";
    echo "- product_id (VARCHAR 36)\n";
    echo "- image_path (VARCHAR 255)\n";
    echo "- is_primary (BOOLEAN)\n";
    echo "- sort_order (INT)\n";
    echo "- created_at (DATETIME)\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
