<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    // Create pivot table for Company <-> Product Categories
    $db->exec("CREATE TABLE IF NOT EXISTS company_product_types (
        company_id INT NOT NULL,
        product_type_id INT NOT NULL,
        PRIMARY KEY (company_id, product_type_id),
        FOREIGN KEY (company_id) REFERENCES companies(id) ON DELETE CASCADE,
        FOREIGN KEY (product_type_id) REFERENCES product_types(id) ON DELETE CASCADE
    )");

    echo "Company-Product Category relationship table created successfully.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
