<?php
namespace Models;

class User {
    public static function getAll($companyId = null, $status = null) {
        $db = \Core\Database::getInstance();
        $sql = "SELECT u.*, c.name as company_name 
                FROM users u 
                LEFT JOIN companies c ON u.company_id = c.id";
        
        $conditions = [];
        $params = [];
        
        if ($companyId) {
            $conditions[] = "u.company_id = ?";
            $params[] = $companyId;
        }
        
        if ($status) {
            $conditions[] = "u.status = ?";
            $params[] = $status;
        }
        
        if (!empty($conditions)) {
            $sql .= " WHERE " . implode(" AND ", $conditions);
        }
        
        $sql .= " ORDER BY u.created_at DESC";
        
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }

    public static function findByEmail($email) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("
            SELECT u.*, c.name as company_name 
            FROM users u 
            LEFT JOIN companies c ON u.company_id = c.id 
            WHERE u.email = ?
        ");
        $stmt->execute([$email]);
        return $stmt->fetch();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public static function create($data) {
        $db = \Core\Database::getInstance();
        $sql = "INSERT INTO users (name, email, password, role, company_id) VALUES (?, ?, ?, ?, ?)";
        $stmt = $db->prepare($sql);
        $companyId = !empty($data['company_id']) ? $data['company_id'] : null;
        return $stmt->execute([$data['name'], $data['email'], password_hash($data['password'], PASSWORD_DEFAULT), $data['role'], $companyId]);
    }

    public static function update($id, $data) {
        $db = \Core\Database::getInstance();
        $companyId = !empty($data['company_id']) ? $data['company_id'] : null;
        $fields = ["name = ?", "email = ?", "role = ?", "company_id = ?"];
        $params = [$data['name'], $data['email'], $data['role'], $companyId];

        if (!empty($data['password'])) {
            $fields[] = "password = ?";
            $params[] = password_hash($data['password'], PASSWORD_DEFAULT);
        }

        $params[] = $id;
        $sql = "UPDATE users SET " . implode(", ", $fields) . " WHERE id = ?";
        $stmt = $db->prepare($sql);
        return $stmt->execute($params);
    }

    public static function updateStatus($id, $status) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("UPDATE users SET status = ? WHERE id = ?");
        return $stmt->execute([$status, $id]);
    }

    public static function count($status = null) {
        $db = \Core\Database::getInstance();
        $sql = "SELECT COUNT(*) FROM users";
        if ($status) {
            $stmt = $db->prepare($sql . " WHERE status = ?");
            $stmt->execute([$status]);
        } else {
            $stmt = $db->query($sql);
        }
        return $stmt->fetchColumn();
    }
}
