<?php
namespace Models;

class ProductImage {
    public static function create($productId, $imagePath, $isPrimary = false) {
        $db = \Core\Database::getInstance();
        $id = self::generateUuid();
        
        $sql = "INSERT INTO product_images (id, product_id, image_path, is_primary) VALUES (?, ?, ?, ?)";
        $stmt = $db->prepare($sql);
        $stmt->execute([$id, $productId, $imagePath, $isPrimary ? 1 : 0]);
        
        return $id;
    }

    public static function getByProduct($productId) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM product_images WHERE product_id = ? ORDER BY is_primary DESC, sort_order ASC, created_at DESC");
        $stmt->execute([$productId]);
        return $stmt->fetchAll();
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("DELETE FROM product_images WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM product_images WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public static function setPrimary($id, $productId) {
        $db = \Core\Database::getInstance();
        $db->beginTransaction();
        try {
            // Unset all others
            $stmt = $db->prepare("UPDATE product_images SET is_primary = 0 WHERE product_id = ?");
            $stmt->execute([$productId]);
            
            // Set new primary
            $stmt = $db->prepare("UPDATE product_images SET is_primary = 1 WHERE id = ?");
            $stmt->execute([$id]);
            
            $db->commit();
            return true;
        } catch (\Exception $e) {
            $db->rollBack();
            return false;
        }
    }

    private static function generateUuid() {
        $data = random_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }
}
