<?php
namespace Models;

class MembershipType {
    public static function getAll() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("
            SELECT mt.*, 
                   COUNT(c.id) as company_count
            FROM membership_types mt
            LEFT JOIN companies c ON mt.id = c.membership_type_id
            GROUP BY mt.id
            ORDER BY mt.price DESC
        ");
        return $stmt->fetchAll();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM membership_types WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public static function create($data) {
        $db = \Core\Database::getInstance();
        $sql = "INSERT INTO membership_types (name, description, price, features, category_limit) VALUES (?, ?, ?, ?, ?)";
        $stmt = $db->prepare($sql);
        return $stmt->execute([
            $data['name'],
            $data['description'] ?? null,
            $data['price'] ?? 0.00,
            $data['features'] ?? null,
            !empty($data['category_limit']) ? $data['category_limit'] : null
        ]);
    }

    public static function update($id, $data) {
        $db = \Core\Database::getInstance();
        $sql = "UPDATE membership_types SET name = ?, description = ?, price = ?, features = ?, category_limit = ? WHERE id = ?";
        $stmt = $db->prepare($sql);
        return $stmt->execute([
            $data['name'],
            $data['description'] ?? null,
            $data['price'] ?? 0.00,
            $data['features'] ?? null,
            !empty($data['category_limit']) ? $data['category_limit'] : null,
            $id
        ]);
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        // Check if any companies are using this membership type
        $stmt = $db->prepare("SELECT COUNT(*) FROM companies WHERE membership_type_id = ?");
        $stmt->execute([$id]);
        $count = $stmt->fetchColumn();
        
        if ($count > 0) {
            return false; // Cannot delete if in use
        }
        
        $stmt = $db->prepare("DELETE FROM membership_types WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public static function count() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("SELECT COUNT(*) FROM membership_types");
        return $stmt->fetchColumn();
    }
}
