<?php
namespace Models;

class CompanyType {
    public static function getAll() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("SELECT * FROM company_types ORDER BY name ASC");
        return $stmt->fetchAll();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM company_types WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public static function create($name) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("INSERT INTO company_types (name) VALUES (?)");
        return $stmt->execute([$name]);
    }

    public static function update($id, $name) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("UPDATE company_types SET name = ? WHERE id = ?");
        return $stmt->execute([$name, $id]);
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("DELETE FROM company_types WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
