<?php
namespace Models;

class Activity {
    public static function log($action, $details = '', $userId = null, $icon = '🔔') {
        $db = \Core\Database::getInstance();
        $userId = $userId ?? ($_SESSION['user_id'] ?? null);
        
        $sql = "INSERT INTO activities (user_id, action, details, icon) VALUES (?, ?, ?, ?)";
        $stmt = $db->prepare($sql);
        return $stmt->execute([$userId, $action, $details, $icon]);
    }

    public static function getRecent($limit = 10) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT a.*, u.name as user_name 
                             FROM activities a 
                             LEFT JOIN users u ON a.user_id = u.id 
                             ORDER BY a.created_at DESC LIMIT ?");
        $stmt->bindValue(1, (int)$limit, \PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
