<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';
require_once __DIR__ . '/app/Models/Activity.php';
require_once __DIR__ . '/app/Core/Auth.php';

// Start session
\Core\Auth::start();

// Set JSON header
header('Content-Type: application/json');

try {
    // Ensure user is logged in
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['error' => 'Unauthenticated', 'details' => 'No active session']);
        exit;
    }
    
    $activities = \Models\Activity::getRecent(10);
    echo json_encode($activities);
    
} catch (Exception $e) {
    error_log("Activity API Error: " . $e->getMessage());
    echo json_encode(['error' => 'Server error', 'message' => $e->getMessage()]);
}
